/*
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */


#include <stdlib.h>
#include <stdio.h>
#include <sys/ioctl.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <asm/types.h>
#include <fcntl.h>
#include <unistd.h>
#include <linux/hiddev.h>
#include <time.h>
#include <linux/input.h>

#include <linux/ioctl.h>
#include "iowarrior.h"


int main (int argc, char **argv) {

	int fd1 = -1;
//	int fd2 = -1;


	if(( fd1 = open( "/dev/usb/iowarrior0", O_RDWR )) < 0 )
	{
		perror( "iowarrior0 open" );
		exit( 1 );
	}
/*
	// If there are more IO-Warriors
	if(( fd2 = open( "/dev/usb/iowarrior2", O_RDWR)) < 0 )
	{
		perror( "iowarrior1 open" );
		exit( 1 );
	}
	// and so on ...
*/

	unsigned long value;

	long time1, time2;
	long * pTime1;
	long * pTime2;

	pTime1 = &time1;
	pTime2 = &time2;

	time( pTime1 );
	*pTime2 = *pTime1;

	int i=0;
	while( i<60 )
	{
		time( pTime2 );
		if( *pTime1 != *pTime2 )
		{
			i++;
			*pTime1 = *pTime2;

			if( ioctl( fd1, IOW_READ, &value ))
			{
				perror( "evdev ioctl" );
				goto end;
			}
			printf ("%08lx\n", value);

			*pTime1 = *pTime2;
		}
	}

end:
	close( fd1 );
//	close( fd2 );
	exit( 0 );
}
